/*
InsertObject, Name, ItemAtPos, ClassType, ClassParent example
For the following example, add a status bar, a list box, and any other components to Form1. Set the SimplePanel property of the status bar to true, using the object inspector.The following code fills a list box with the names of all components on the form when the form is created. References to the components themselves are inserted along with the names.  The components are all inserted at the front of the list, so that the last component added to the form is the first component in the list.
When the user right-clicks the name of an object in the list, the components coordinates are displayed on the status bar. Note that because we are using the right-click, the item need not be selected.
*/ 
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  for (int i = 0; i < ComponentCount; i++)
    ListBox1->Items->InsertObject(0,
                                  Components[i]->Name, 
                                  (TObject *)Components[i]);
}
void __fastcall TForm1::ListBox1MouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y)
{
  if (Button == mbRight)
  {
    TClass ClassRef;
    int Index = ListBox1->ItemAtPos(Point(X,Y), true);
    // only components that are controls have a position
    // make sure the component is a control
    for (ClassRef = ListBox1->Items->Objects[Index]->ClassType();
         ClassRef != NULL;
         ClassRef = ClassRef->ClassParent())
      if (String(ClassRef->ClassName()) == "TControl")
      {
        TControl *TheObject = (TControl *)ListBox1->Items->Objects[Index];
        StatusBar1->SimpleText =
          TheObject->Name + " is at (" +
          IntToStr(TheObject->Left) + ", " +
          IntToStr(TheObject->Top) + ")";
         break;
      }
    if (ClassRef == NULL) // if it wasn't a control
      MessageBeep(0);
  }
} 
