//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "InsertRecord.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
#include <DBTables.hpp>
TForm1 *Form1;
TTable *Customers;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: InsertRecord
// Method: DB.TDataSet.InsertRecord

// BeginCode
/*
This statement inserts a record to the MyCustInfo data. Note
that Nulls are entered for some of the values, but are not
required for missing values at the end of the array argument,
i.e. after the Field3 field.  InsertRecord behaves differently
depending on the indexing of the table.
*/

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Customers->InsertRecord(ARRAYOFCONST((
	Edit1->Text, Edit2->Text, NULL,
	Edit3->Text)));
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Customers = new TTable(Form1);
  Customers->Active = false; // The Table component must not be active
  Customers->DatabaseName = "DBDEMOS";
  Customers->TableType = ttParadox;
  Customers->TableName = "CustInfo";
  if (Customers->Exists)
	MessageDlg("CustInfo table already exists.", mtWarning, TMsgDlgButtons() << mbOK, 0);
  else // Don't overwrite an existing table
  {
	// describe the fields in the table
	Customers->FieldDefs->Clear();
	TFieldDef *newDef = Customers->FieldDefs->AddFieldDef();
	newDef->Name = "Field1";
	newDef->DataType = ftInteger;
	newDef->Required = true;
	newDef = Customers->FieldDefs->AddFieldDef();
	newDef->Name = "Field2";
	newDef->DataType = ftString;
	newDef->Size = 30;
	newDef = Customers->FieldDefs->AddFieldDef();
	newDef->Name = "Field3";
	newDef->DataType = ftString;
	newDef->Size = 30;
	newDef = Customers->FieldDefs->AddFieldDef();
	newDef->Name = "Field4";
	newDef->DataType = ftString;
	newDef->Size = 30;
	// Next, describe any indexes
	Customers->IndexDefs->Clear();
	/* the 1st index has no name because it is a Paradox primary key */
	Customers->IndexDefs->Add("","Field1", TIndexOptions() <<ixPrimary << ixUnique);
	Customers->IndexDefs->Add("Fld2Index", "Field2", TIndexOptions() << ixCaseInsensitive);
	// Now that we have specified what we want, create the table
	Customers->CreateTable();
	Customers->Active = True;
	for (int i = 1; i <= 20; i++)
	  Customers->AppendRecord(ARRAYOFCONST((i*111, i*222, i*333, i*444)));
  }
  DS2->DataSet = Customers;
  DBGrid2->DataSource->DataSet = Customers;
  Customers->Active = True;
}
// EndCode
// EndExample: InsertRecord
//---------------------------------------------------------------------------
