//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "LastOSError_cpp.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: LastOSError
// Routine: SysUtils.RaiseLastOSError
// Routine: System.SetLastError
// Routine: System.GetLastError

// BeginCode
//
//This code demonstrates the use of system error codes
//and how to use transform them into C++ exceptions.
//
void __fastcall TForm2::btRaiseLastClick(TObject *Sender)
{
	/* Set the last OS error to a bogus value */
	System::SetLastError(ERROR_ACCESS_DENIED);

	try
	{
		RaiseLastOSError();
	}
	catch(EOSError* ex)
	{
		MessageDlg(String("Caught an OS error with code: ") +
			IntToStr((int)ex->ErrorCode), mtError,
			TMsgDlgButtons() << mbOK, 0);
	}


	/* Let the Delphi's Exception dialog pop-up */
	RaiseLastOSError(ERROR_NOT_ENOUGH_MEMORY);

	/* Finally set the last error to none */
	System::SetLastError(ERROR_SUCCESS);

	if (GetLastError() != ERROR_SUCCESS)
		MessageDlg(String("Whoops, something went wrong ") +
		  " in the mean time!", mtError, TMsgDlgButtons() << mbOK, 0);

	/* No exception should be thrown here */
	RaiseLastOSError();
}
// EndCode
// EndExample: LastOSError
//---------------------------------------------------------------------------
