//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "LoadFromClipboard.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: LoadFromClipBoard
// Method: Graphics.TBitmap.LoadFromClipboardFormat
// Method: Graphics.TBitmap.SaveToClipboardFormat
// Method: Graphics.TPicture.RegisterClipboardFormat
// Routine: Clipbrd.Clipboard
// Method: Clipbrd.TClipboard.GetAsHandle
// Method: Clipbrd.TClipboard.SetAsHandle
// Method: Clipbrd.TClipboard.Clear

// BeginCode
/*
The following code draws a bitmap image from the Clipboard 
when a button is pressed.  The SaveToClipboard button must 
be selected before the LoadFromClipboard button in order to
place the icon on the clipboard.
*/
#include <Clipbrd.hpp>
#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TClipboard *cb = Clipboard();
  if (cb->HasFormat(CF_BITMAP))
  {
	std::auto_ptr<Graphics::TBitmap> Bitmap(new Graphics::TBitmap());
	try
	{
	  Bitmap->LoadFromClipboardFormat(CF_BITMAP, cb->GetAsHandle(CF_BITMAP), 0);
	  Canvas->Draw(5, 5, Bitmap.get());
    }
	catch (...)
	{
	  MessageBeep(0);
	  ShowMessage("Error reading image from clipboard!");
	}
	cb->Clear();
  }
  else
  {
	MessageBeep(0);
	ShowMessage("Cannot find image in clipboard!");
  }
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  unsigned int DataHandle;
  HPALETTE APalette;
  unsigned short MyFormat;
  std::auto_ptr<Graphics::TBitmap> Bitmap(new Graphics::TBitmap());
  try
  {
	Bitmap->LoadFromFile("C:\\Program Files\\Common Files\\CodeGear Shared\\Images\\Splash\\256Color\\FACTORY.BMP");
	// generate a clipboard format, with data and palette
	Bitmap->SaveToClipboardFormat(
	  MyFormat,
	  DataHandle,
	  APalette);
    // save the data to the clipboard using that format and
    // the generated data
    Clipboard()->SetAsHandle(MyFormat,DataHandle);
  }
  catch (...)
  {
	 ShowMessage("Failed to copy image to clipboard!");
  }
}
// EndCode
// EndExample: LoadFromClipBoard
//---------------------------------------------------------------------------

