/*
LoadFromClipboardFormat example
The following code draws a bitmap image from the clipboard when a button is pressed.
*/ 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TClipboard *pCB = Clipboard();
  if (pCB->HasFormat(CF_BITMAP))
  {
    Graphics::TBitmap *pBitmap = new Graphics::TBitmap();
    try
    {
      pBitmap->LoadFromClipboardFormat(CF_BITMAP, pCB->GetAsHandle(CF_BITMAP), 0);
      Canvas->Draw(5,5,pBitmap);
    }
    catch (...)
    {
      MessageBeep(0);
    }
    delete pBitmap;
  }
  else
    MessageBeep(0);
} 
