//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "LoadFromFile.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: LoadFromFile
// Method: Graphics.TBitmap.Assign
// Method: Graphics.TBitmap.Dormant
// Method: Graphics.TBitmap.FreeImage
// Property: Graphics.TBitmap.Monochrome
// Method: Graphics.TBitmap.ReleaseHandle
// Property: Graphics.TGraphic.LoadFromFile

// BeginCode
/*
This example uses a button on a form and creates two bitmaps
dynamically.  One bitmap is monchrome, which means all
non-white colors become black.  The bitmap file path is
relative to the Debug directory.
Note: For the C++ Builder, capitalization matters for the file
name and path.
*/

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  std::auto_ptr<Graphics::TBitmap> Bitmap1(new Graphics::TBitmap());
  std::auto_ptr<Graphics::TBitmap> Bitmap2(new Graphics::TBitmap());
  try
  {
	Bitmap1->LoadFromFile("..\\FACTORY.BMP");
	Bitmap2->Assign(Bitmap1.get());     // Copy Bitmap1 into Bitmap2
    Bitmap2->Dormant();           // Free up GDI resources
    Bitmap2->FreeImage();         // Free up Memory.
	Canvas->Draw(20, 20, Bitmap2.get());  // Note that previous calls don't lose the image
    Bitmap2->Monochrome = true;
	Canvas->Draw(80, 80, Bitmap2.get());
    Bitmap2->ReleaseHandle();       // This will actually lose the bitmap;
  }
  catch (...)
  {
    MessageBeep(0);
  }
}
// EndCode
// EndExample: LoadFromFile
//---------------------------------------------------------------------------
