//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "LoadFromStream.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  ListBox1->Items->Add("Apples");
  ListBox1->Items->Add("Oranges");
  ListBox1->Items->Add("Pears");
}
//---------------------------------------------------------------------------
// BeginExample: LoadFromStream
// Method: Classes.TStrings.LoadFromStream
// Method: Classes.TStrings.SaveToStream
// Property: Classes.TStream.Position

// BeginCode
/*
This example requires TListBox, TMemo, TRichEdit, and
TButton controls placed on the form. The list box should
contain one or more items.  When the form becomes visible,
click on the button and the contents of the list box will be
transferred to a stream and then to the rich edit control.
*/
#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  std::auto_ptr<TMemoryStream> pms(new TMemoryStream());
  ListBox1->Items->SaveToStream(pms.get()); // write list box contents to the
                                      // stream.
  pms->Position = 0;                  // reset to the beginning of the stream.
  RichEdit1->Lines->LoadFromStream(pms.get()); // load stream contents into rich
										 // edit control.
}
// EndCode
// EndExample: LoadFromStream
//---------------------------------------------------------------------------
