/*
SaveToStream, LoadFromStream example
This example requires TListBox, TMemo, TRichEdit, and TButton controls placed on the form. The list box should contain one or more items.
When the form becomes visible, click on the button and the contents of the list box will be transferred to the memo (cross-platform) or rich edit (Windows) control.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TMemoryStream* pms = new TMemoryStream();
  ListBox1->Items->SaveToStream(pms); // write list box contents to the
                                      // stream.
  pms->Position = 0;                  // reset to the beginning of the stream.
  RichEdit1->Lines->LoadFromStream(pms); // load stream contents into rich
                                         // edit control.
  delete pms;
}
 
