//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MediaPlayer_cpp.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner)
{
}

// BeginExample: MediaPlayer
// Class: MPlayer.TMediaPlayer
// Property: MPlayer.TMediaPlayer.FileName
// Method: MPlayer.TMediaPlayer.Open
// Method: MPlayer.TMediaPlayer.Play
// Property: MPlayer.TMediaPlayer.AutoEnable
// Property: MPlayer.TMediaPlayer.EnabledButtons

// BeginCode
//
//This example demonstrates the use of TMediaPlayer component. Assuming 2 buttons
//for Open and Stop are present on the form.
//Note: AutoEnable must be set to false to be able to control
//the buttons manually.
//
void __fastcall TForm2::btOpenClick(TObject *Sender)
{
	TOpenDialog* OpenMediaDialog;

	OpenMediaDialog = new TOpenDialog(this);
	OpenMediaDialog->Filter = "All Video Files (*.avi)|*.avi";
  // There are avi files in
  // C:\Documents and Settings\All Users\Documents\RAD Studio\6.0\Demos\DelphiWin32\VCLWin32\CoolStuff
	if (OpenMediaDialog->Execute())
	{
		/* Assign a file to the media player */
		MediaPlayer1->FileName = OpenMediaDialog->FileName;

		/* Check if the file exists and is not a directory */
		if ((FileExists(OpenMediaDialog->FileName)) &&
		   (!DirectoryExists(OpenMediaDialog->FileName)))
		{
			/* Open the files */
			MediaPlayer1->Wait = true;
			MediaPlayer1->Open();
			MediaPlayer1->Play();

			/* Override automatic button controlling */
			MediaPlayer1->EnabledButtons =
				TButtonSet() <<
				TMPBtnType::btPause <<
				TMPBtnType::btStop <<
				TMPBtnType::btPlay;


			/* Enable  the stop button */
			btStop->Enabled = true;
			btOpen->Enabled = false;
        }
	}

	delete OpenMediaDialog;
}

void __fastcall TForm2::btStopClick(TObject *Sender)
{
	/* Stop and close the media */
	MediaPlayer1->Stop();
	MediaPlayer1->Close();

	MediaPlayer1->EnabledButtons = TButtonSet();

	/* Enable open button again */
	btOpen->Enabled = true;
}

void __fastcall TForm2::FormCreate(TObject *Sender)
{
	/* Disable all buttons */
	MediaPlayer1->AutoEnable = false;
	MediaPlayer1->EnabledButtons = TButtonSet();
}

void __fastcall TForm2::MediaPlayer1PostClick(TObject *Sender,
		  TMPBtnType Button)
{
	if (Button == TMPBtnType::btStop)
		btStop->Click();
}

// EndCode
// EndExample: MediaPlayer

//---------------------------------------------------------------------------

