//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OnActivate.h"
#include <DBTables.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}

// BeginExample: OnActivate
// Event: Forms.TCustomForm.OnActivate
// Property: Classes.TComponent.ComponentCount
// Property: Classes.TComponent.Components

// BeginCode
/*
This example fills a list box with the names of TDataSources
that are present and then fills a DBGrid a second form with
the data from the selected data source.  The DBGrid is not
filled in until Form2 is activated.  Here is the code for Form1
that fills the list box.
*/

TForm1 *Form1;
TTable *Customers, *Blobs;
Boolean Form1Done = False;

void CreateCustSource()
{
  Customers = new TTable(Form1); // The owner will clean this up.
  Customers->Active = false; // The Table component must not be active
  Customers->DatabaseName = "DBDEMOS";
  Customers->TableType = ttParadox;
  Customers->TableName = "CustInfo";
  Customers->Active = False;
  if (Customers->Exists) // Don't overwrite an existing table
  {
	Customers->Close();
	Customers->DeleteTable();
  }
  // The Table component must not be active
  // First, describe the type of table and give
  // it a name
  // Next, describe the fields in the table
  Customers->FieldDefs->Clear();
  TFieldDef *pNewDef = Customers->FieldDefs->AddFieldDef();
  pNewDef->Name = "Field1";
  pNewDef->DataType = ftInteger;
  pNewDef->Required = true;
  pNewDef = Customers->FieldDefs->AddFieldDef();
  pNewDef->Name = "Field2";
  pNewDef->DataType = ftString;
  pNewDef->Size = 30;
  // Next, describe any indexes
  Customers->IndexDefs->Clear();
  /* the 1st index has no name because it is a Paradox primary key */
  Customers->IndexDefs->Add("","Field1", TIndexOptions() <<ixPrimary << ixUnique);
  Customers->IndexDefs->Add("Fld2Index","Field2", TIndexOptions() << ixCaseInsensitive);
  // Now that we have specified what we want, create the table
  Customers->CreateTable();
  Customers->Active = True;
  for (int i = 1; i <= 20; i++)
	Customers->AppendRecord(ARRAYOFCONST((i*111, i*222)));
  Form1->CustomerDS->DataSet = Customers;
  Customers->Active = True;
}

void CreateBlobSource()
{
  int i;
  Blobs = new TTable(Form1);
  Blobs->DatabaseName = "DBDEMOS";
  Blobs->TableType = ttParadox;
  Blobs->TableName = "MyBlobInfo";
  Blobs->Active = False;
	// Don't overwrite an existing table
//    if Blobs.Exists then
//      MessageDlg('CustInfo table already exists.', mtWarning, [mbOK], 0)
//    else
  if (Blobs->Exists)
  {
	Blobs->Close();
	Blobs->DeleteTable();
  };
  // The Table component must not be active }
  // First, describe the type of table and give }
  // it a name }
  // Next, describe the fields in the table }
  Blobs->FieldDefs->Clear();
  TFieldDef *newDef = Blobs->FieldDefs->AddFieldDef();
  newDef->Name = "Field1";
  newDef->DataType = ftInteger;
  newDef->Required = True;
  newDef = Blobs->FieldDefs->AddFieldDef();
  newDef->Name = "Field2";
  newDef->DataType = ftBlob;
  newDef->Size = 30;
  // Next, describe any indexes }
  Blobs->IndexDefs->Clear();
  // The 1st index has no name because it is
  // a Paradox primary key }
  TIndexDef *newIDef = Blobs->IndexDefs->AddIndexDef();
  newIDef->Name = "";
  newIDef->Fields = "Field1";
  newIDef->Options << ixPrimary;
/*
		with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
*/
  // Call the CreateTable method to create the table }
  Blobs->CreateTable();
  Blobs->Active = True;
  for (int i = 1; i <= 20; i++)
	Blobs->AppendRecord(ARRAYOFCONST((i*111, IntToStr(i*222))));
  Form1->BlobDS->DataSet = Blobs;
  Blobs->Active = True;
};


void __fastcall TForm1::FormCreate(TObject *Sender)
{
  CreateCustSource();
  CreateBlobSource();
  for (int i = 0; i < ComponentCount; i++)
  {
	if (Components[i]->ClassNameIs("TDataSource"))
	  ListBox1->Items->AddObject(Components[i]->Name,
		 dynamic_cast<TObject *>(Components[i]));
  }
}

void __fastcall TForm1::ListBox1MouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift,
          int X, int Y)
{
  Form1Done = True;
}
// EndCode
// EndExample: OnActivate
//---------------------------------------------------------------------------

