
(*
 Delphi Object and Component Reference
# {bmc bm9.BMP} OnActivate, ComponentCount, Components, ClassNameIs example
The following code sets the DataSource for a DBGrid component in Form2 to the currently selected data source in a list provided in Form1. This allows users to specify the desired information in Form1, and then move to Form2 to view the information.
*) 
void __fastcall TForm2::FormActivate(TObject *Sender)
{
  DBGrid1->DataSource = (TDataSource *)
    Form1->ListBox1->Objects[Form1->ListBox1->ItemIndex];
}
Here is the code on Form1 that fills the list box:
*) 
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  for (int i = 0; i < DataModule2->ComponentCount; i++)
  {
    if (DataModule2->Components[i]->ClassNameIs("TDataSource"))
      ListBox1->Items->AddObject(DataModule2->Components[i]->Name,
        (TObject *)DataModule2->Components[i]);
  }
} 
