//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OnActiveControlChange.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: OnActiveControlChange
// Event: Forms.TScreen.OnActiveControlChange
// Method: Controls.TWinControl.Focused
// Event: Forms.TCustomForm.OnDestroy

// BeginCode
/*
This example uses the OnActiveControlChange event to detect
when focus changes on the form. When focus changes, the hint
for the active control is displayed on the status bar. To use
this example, you must add a status bar to the form and set 
its SimplePanel property to true.  Add a new public procedure,
ActiveControlChanged, to the TForm1 class declaration.
*/
void _fastcall TForm1::ActiveControlChanged(System::TObject *Sender)
{
  TWinControl *Active = NULL;
  for (int I = 0; I < Form1->ControlCount; I++)
  {
	TWinControl *Temp = dynamic_cast<TWinControl *>(Form1->Controls[I]);
	if (Temp && Temp->Focused())
	  Active = Temp;
  }
  if ((Active != NULL) && (Active->Hint != ""))
	StatusBar2->SimpleText = GetLongHint(Active->Hint) + " focus";
}

void __fastcall TForm1::MouseOverChanged(TObject *Sender)
{
  TWinControl *Active = dynamic_cast<TWinControl *>(Sender);
  if (Active != NULL)
	StatusBar1->SimpleText = GetLongHint(Active->Hint) + " mouse over";
}

/*
Assign this method as the OnActiveControlChange event
handler by setting it from the form's OnCreate event handler:
*/
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Screen->OnActiveControlChange = ActiveControlChanged;
}

/*
Make sure you clean up the screen object when the form is
freed by adding this OnDestroy event handler to the form:
*/
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  Screen->OnActiveControlChange = 0;
}
// EndCode
// EndExample: OnActiveControlChange
//---------------------------------------------------------------------------

