/*
OnActiveControlChange, Focused example
This example uses the OnActiveControlChange event to detect when focus changes on the form. When focus changes, the hint for the active control is displayed on the status bar. To use this example, you must add a status bar to the form and set its SimplePanel property to true.
This example can be adapted for an application using Windows-only components. Simply replace the object name TWidgetControl with its Windows-only counterpart, TWinControl.
Add a new public procedure, ActiveControlChanged, to the TForm1 class declaration in the header file.
Implement this procedure as follows:
*/ 
void _fastcall TForm1::ActiveControlChanged(System::TObject *Sender)
{
  for (int I = 0; I < Form1->ControlCount; I++)
  {
    TWidgetControl *Temp = dynamic_cast<TWidgetControl *>(Form1->Controls[I]);
    if (Temp && Temp->Focused())
    {
      StatusBar1->SimpleText = GetLongHint(Temp->Hint);
      return;
    }
  }
}
/*
Assign this method as the OnActiveControlChange event handler by setting it from the form's OnCreate event handler (Be sure that the form's OldCreateOrder property is false):
*/ 
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Screen->OnActiveControlChange = ActiveControlChanged;
}
/*
Make sure you clean up the screen object when the form is freed by adding this OnDestroy event handler to the form (Be sure that the form's OldCreateOrder property is false):
*/
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  Screen->OnActiveControlChange = 0;
} 
