/*
OnCloseQuery example
When the user attempts to close the form in this example, a message dialog appears that asks the user if it is OK to close the form. If the user chooses the OK button, the form closes. If the user chooses Cancel, the form doesn't close.
*/
On Windows:
void __fastcall TForm1::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  if (MessageDlg("Close the form?", mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel,0) == mrCancel)
    CanClose = false;
}
On Cross-platform:
void __fastcall TForm1::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  if (MessageDlg("Close the form?", mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel,0) == mrCancel, mbOK, NULL)
    CanClose = false;
} 
