//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OnDragOver.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: OnDragOver
// Event: Controls.TControl.OnDragOver
// Event: Controls.TControl.OnDragDrop
// Property: Controls.TWinControl.DoubleBuffered

// BeginCode
/*
This code comes from an application that contains a list box
and three labels, each with a different font and color.  The
DragMode property for each of the labels is dmAutomatic.
The user can select a label and drag it to a list box and
drop it. When the label is dropped, the items in the list
box assume the color and font of the dropped label.
*/

// This OnDragOver event handler permits the list box to
// accept a dropped label:
void __fastcall TForm1::ListBox1DragOver(TObject *Sender, TObject *Source, int X, int Y, TDragState State, bool &Accept)
{
   Accept = Source->ClassNameIs("TLabel");
}

/*
This OnDragDrop event handler implements the drop behavior.
*/ 
void __fastcall TForm1::ListBox1DragDrop(TObject *Sender, TObject *Source, int X, int Y)
{
  if (Sender->ClassNameIs("TListBox") && Source->ClassNameIs("TLabel"))
  {
	TListBox *DestList = dynamic_cast<TListBox *>(Sender);
	DestList->Font = (dynamic_cast<TLabel *>(Source))->Font;
	DestList->Color = (dynamic_cast<TLabel *>(Source))->Color;
	DestList->DoubleBuffered = true;
	DestList->Color = clWindow;
  }
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  ListBox1->Items->Add("Not");
  ListBox1->Items->Add("In");
  ListBox1->Items->Add("Alphabetical");
  ListBox1->Items->Add("Order");

}
// EndCode
// EndExample: OnDragOver
//---------------------------------------------------------------------------
