/*
OnDragOver, OnDragDrop example
This code comes from an application that contains a list box and three labels, each with a different font and color.  The DragMode property for each of the labels is dmAutomatic.  The user can select a label and drag it to a list box and drop it. When the label is dropped, the items in the list box assume the color and font of the dropped label. 
This OnDragOver event handler permits the list box to accept a dropped label:
*/ 
void __fastcall TForm1::ListBox1DragOver(TObject *Sender, TObject *Source, int X, int Y, TDragState State, bool &Accept)
{
   Accept = Source->ClassNameIs("TLabel");
}
/*
This OnDragDrop event handler implements the drop behavior.
*/ 
void __fastcall TForm1::ListBox1DragDrop(TObject *Sender, TObject *Source, int X, int Y)
{
  if (Sender->ClassNameIs("TListBox") && Source->ClassNameIs("TLabel"))
  {
    TListBox *DestList = (TListBox *)Sender;
    DestList->Font = ((TLabel *)Source)->Font;
    DestList->Color = ((TLabel *)Source)->Color;
  }
} 
