//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OnDrawCell.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: OnDrawCell
// Event: Grids.TCustomDrawGrid.OnDrawCell
// Event: Grids.TCustomDrawGrid.OnSelectCell
// Property: Controls.TCustomControl.Canvas
// Method: Graphics.TCanvas.DrawFocusRect
// Method: ImgList.TCustomImageList.Draw
// Property: Grids.TCustomGrid.Options
// Type: Grids.TGridOptions

// BeginCode
/*
The following code uses the bitmaps in an image list
component to draw the contents of each cell in a draw grid.
It draws a focus rectangle around the cell that has focus.
goDrawFocusSelect in the DrawGrid Options parameter must be
True to set focus on a cell.  The ImageList Draw method must
be called after DrawFocusRect. The OnSelectCell event handler
must implemented to return true.
*/
void __fastcall TForm1::DrawGrid1DrawCell(
  TObject *Sender, int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
  long index = ARow * DrawGrid1->ColCount + ACol;
  DrawGrid1->Canvas->Brush->Color = clBackground;
  DrawGrid1->Canvas->FillRect(Rect);
  if (State.Contains(gdFocused))
  {
	DrawGrid1->Canvas->DrawFocusRect(Rect);
	Label1->Caption = "Cell " + IntToStr(int(index)) + " has the focus.";
  }
  ImageList1->Draw(
	DrawGrid1->Canvas, Rect.Left, Rect.Top, index, True);
}

void __fastcall TForm1::DrawGrid1SelectCell(TObject *Sender, int ACol, int ARow,
      bool &CanSelect)
{
  CanSelect= True;
}
// EndCode
// EndExample: OnDrawCell
//---------------------------------------------------------------------------
