//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OnDrawPanel.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: OnDrawPanel

// Event: ComCtrls.TStatusBar.OnDrawPanel
// Event: ComCtrls.TCustomStatusBar.OnDrawPanel
// Property: ComCtrls.TCustomStatusBar.Canvas
// Property: ComCtrls.TCustomStatusBar.Panels
// Method: ImgList.TCustomImageList.Draw
// Property: ComCtrls.TStatusPanel.Style

// BeginCode
/*
The following code is the OnDrawPanel event handler of a
status bar.  It draws each panel of the status bar, adding
text and icons stored in ImageList1. The image list contains
as many icons as there are header sections.  This example
requires a populated image list and a statusbar with several
panels added to the Panels property.  Select each panel and
set the Style property to psOwnerDraw.
*/
void __fastcall TForm1::StatusBar1DrawPanel(TStatusBar *StatusBar,
        TStatusPanel *Panel, const TRect &Rect)
{
  TCanvas *canvas = StatusBar->Canvas;
  canvas->Brush->Color = clRed;
  canvas->FillRect(Rect);
  canvas->Font->Color = clYellow;
  ImageList1->Draw(canvas,Rect.Left,Rect.Top, Panel->Index, true);
  canvas->TextOut(Rect.left + 30, Rect.top + 2, "Panel" + IntToStr(Panel->Index));
}
// EndCode
// EndExample: OnDrawPanel
//---------------------------------------------------------------------------
