//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OnDropDown.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: OnDropDown
// Event: StdCtrls.TCustomCombo.OnDropDown
// Property: StdCtrls.TCustomComboBox.Sorted
// Method: Classes.TStrings.Clear
// Method: Classes.TStrings.BeginUpdate
// Method: Classes.TStrings.EndUpdate

// BeginCode
/*
This example fills the list of a combo box with the set of
open forms when the user drops down the list. The list is
regenerated every time the list is dropped down, so if the
application opens or closes forms, the combo box stays current.
*/
#include "Unit2.h"
#include "Unit3.h"

void __fastcall TForm1::ComboBox1DropDown(TObject *Sender)
{
  ComboBox1->Items->BeginUpdate(); // prevent repaints until done
  ComboBox1->Items->Clear(); // empty the list of any old values
  for (int i = 0; i < Screen->CustomFormCount; i++)
  {
	if ((reinterpret_cast<TForm1 *>(Screen->CustomForms[i]))->Visible)
	  ComboBox1->Items->Add(Screen->CustomForms[i]->Caption);  // add form names
  }
  ComboBox1->Items->EndUpdate(); //reenable painting
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  ComboBox1->Sorted = True; // make sure the form names are sorted
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Form2->Show();
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  Form3->Show();
}
// EndCode
// EndExample: OnDropDown
//---------------------------------------------------------------------------

