/*
OnDropDown, Sorted, Clear, BeginUpdate, EndUpdate example
This example fills the list of a combo box with the set of open forms when the user drops down the list.  The list is regenerated every time the list is dropped down, so if the application opens or closes forms, the combo box stays current.
*/ 
void __fastcall Form1::ComboBox1DropDown(TObject *Sender)
{
  FormCombo->Items->BeginUpdate(); // prevent repaints until done
  FormCombo->Items->Clear(); // empty the list of any old values
  FormCombo->Sorted = true; // make sure the form names are sorted
  for (int i = 0; i < Screen->CustomFormCount; i++) // add form names
  {
    FormCombo->Items->Add(Screen->CustomForms[i]->Caption); 
  }
  FormCombo->Items->EndUpdate(); //reenable painting 
} 
