{
Here is a typical handler for an OnMeasureItem event. The
example assumes that a variable owner-draw list box already
has bitmaps associated with each of its strings. It sets the
height of the item to the height of the associated bitmap if
that height is greater than the default height.
Note that TWinControl can also be used in place of
TWidgetControl on Windows.
}
procedure TForm1.ListBox1MeasureItem(Control: TWinControl; Index: Integer;
  var Height: Integer);
var
  Bitmap: TBitmap;
begin
  if (Control is TListBox) then
  begin
    with Control as TListBox do
    begin
      Bitmap := TBitmap(Form1.ListBox1.Items.Objects[Index]);
      if Bitmap <> nil then
        if Bitmap.Height > Height then Height := Bitmap.Height;
    end;
  end;
end;

