//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OnMessage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: OnMessage
// Event: Forms.TApplication.OnMessage

// BeginCode
/*
The following code handles a custom message that the
application sends to itself when a file is ready for reading.
*/
const WM_FILEREADY = WM_USER + 2000;

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  const PAnsiChar Path = "../overview.rtf";
  PostMessage(Application->Handle, WM_FILEREADY, 0, int(Path));
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Application->OnMessage = AppMessage;
}

void __fastcall TForm1::AppMessage(tagMSG &Msg, bool &Handled)
{
  if (Msg.message == WM_FILEREADY)
  {
	Memo1->Lines->LoadFromFile(AnsiString((char *)Msg.lParam));
    Handled = true;
  }
/*
For all other messages, Handled remains False so that other
message handlers can respond.
*/
}
// EndCode
// EndExample: OnMessage
//---------------------------------------------------------------------------
