/*
OnMessage example
The following code handles a custom message that the application sends to itself when a file is ready for reading.
*/ 
const WM_FILEREADY = WM_USER + 2000;
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Application->OnMessage = AppMessage;
}

void __fastcall TForm1::AppMessage(tagMSG &Msg, bool &Handled)
{
  if (Msg.message == WM_FILEREADY)
  {
    Memo1->Lines->LoadFromFile(AnsiString((char *)Msg.lParam));
    Handled = true;
  }
  /* for all other messages, Handled remains False so that other message handlers can respond */
} 
