/*
OnMouseDown, OnMouseMove, OnMouseUp, Panels, Text example
The following example requires a form with a four-paneled status bar.  (Set the Width of the status panels to 150 before running this example).  When the user presses a mouse button, moves the mouse, and releases the mouse button, a rectangle is drawn on the form. When the mouse button is released, the rectangle appears on the forms canvas. Its top-left and bottom-right corners are defined by the location of the mouse pointer when the user pressed and released the mouse button.  While the user drags the mouse, the location of the top, left, bottom, and right sides of the rectangle are displayed in the status bar.
*/
int StartX, StartY; // Declare at the top of the forms unit
// Use this code as the OnMouseDown event handler of the form:
void __fastcall TForm1::Button1MouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y)
{
  StartX = X;
  StartY = Y;
}
// Use this code as the OnMouseUp event handler of the form:
void __fastcall TForm1::FormMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y)
{
  Form1->Canvas->Rectangle(StartX, StartY, X, Y);
  StatusBar1->Panels->Items[0]->Text = "";
  StatusBar1->Panels->Items[1]->Text = "";
  StatusBar1->Panels->Items[2]->Text = "";
  StatusBar1->Panels->Items[3]->Text = "";
}
// Use this code as the OnMouseMove event handler of the form:
void __fastcall TForm1::FormMouseMove(TObject *Sender, TShiftState Shift, int X, int Y)
{
  if (Shift.Contains(ssLeft)) // make sure button is down
  {
    if (Y > StartY)
    {
      StatusBar1->Panels->Items[0]->Text = "Top: " + IntToStr(StartY);
      StatusBar1->Panels->Items[2]->Text = "Bottom: " + IntToStr(Y);
    }
    else
    {
      StatusBar1->Panels->Items[0]->Text = "Top: " + IntToStr(Y);
      StatusBar1->Panels->Items[2]->Text = "Bottom: " + IntToStr(StartY);
    }
    if (X > StartX)
    {
      StatusBar1->Panels->Items[1]->Text = "Left: " + IntToStr(StartX);
      StatusBar1->Panels->Items[3]->Text = "Right: " + IntToStr(X);
    }
    else
    {
      StatusBar1->Panels->Items[1]->Text = "Left: " + IntToStr(X);
      StatusBar1->Panels->Items[3]->Text = "Right: " + IntToStr(StartX);
    }
  }
} 
