//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OnMoved.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: OnMoved
// Event: ExtCtrls.TSplitter.OnMoved
// Property: Controls.TControl.Cursor

// BeginCode
/*
This example uses a splitter and two image controls to
create a "slide show" effect.  The example displays an image
(the current "slide"), which can be hidden behind a screen
that looks like a venetian blind. When the blind is pulled
down to completely cover the current slide, the slide changes
to a different image.  When the blind is raised, the new
image appears.
To prepare this example, follow these steps:
1. Place an image control on the form.
Set the picture property to a bitmap of a venetian blind,
Set the Stretch property to True.
Set the Align property to alTop.
2. Add a splitter control to the form.
Set the Align property to alTop.
Set the Cursor property to crVSplit.
Set the OnMoved event handler to the code that appears below.
Set the MinSize property to 1.
3. Add a second image control to the form.
Set the Align property to alClient.
Set the Stretch property to True.
4. Select the form and add the OnCreate and OnDestroy event
   handlers that appear below.
5. Add the global variables below to the unit.
*/
int CurImage;
Graphics::TBitmap *BMPs[5];

void __fastcall TForm1::Splitter1Moved(TObject *Sender)
{
  // check if the blind is closed
  if (Image2->Height <= 1)
  {
    // the blind is closed, change the current slide
	CurImage++;
	if (CurImage == 5)
       CurImage = 0;
    Image2->Picture->Bitmap = BMPs[CurImage];
  }
}

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // Initialize the array of slides.
  // These must be freed in the OnDestroy event handler.

  static std::auto_ptr<Graphics::TBitmap> _MyBMP0Cleaner(BMPs[0] = new Graphics::TBitmap);
  BMPs[0]->LoadFromFile("..\\factory.bmp");

  static std::auto_ptr<Graphics::TBitmap> _MyBMP1Cleaner(BMPs[1] = new Graphics::TBitmap);
  BMPs[1]->LoadFromFile("..\\Rhododendron.bmp");

  static std::auto_ptr<Graphics::TBitmap> _MyBMP2Cleaner(BMPs[2] = new Graphics::TBitmap);
  BMPs[2]->LoadFromFile("..\\littleB_64.bmp");

  static std::auto_ptr<Graphics::TBitmap> _MyBMP3Cleaner(BMPs[3] = new Graphics::TBitmap);
  BMPs[3]->LoadFromFile("..\\Soap Bubbles.bmp");

  static std::auto_ptr<Graphics::TBitmap> _MyBMP4Cleaner(BMPs[4] = new Graphics::TBitmap);
  BMPs[4]->LoadFromFile("..\\Gone Fishing.bmp");

  CurImage = 0;

  Image2->Picture->Bitmap = BMPs[0];
}
// EndCode
// EndExample: OnMoved
//---------------------------------------------------------------------------
