
(*
 Delphi Object and Component Reference
#{bmc bm9.BMP} OnMoved example
This example uses a splitter and two image controls to create a slide show effect. The example displays an image (the current slide), which can be hidden behind a screen that looks like a venetian blind. When the blind is pulled down to completely cover the current slide, the slide changes to a different image.  When the blind is raised, the new image appears.
To prepare this example, follow these steps:
1. Place an image control on the form.  
Set the picture property to a bitmap of a venetian blind, 
Set the Stretch property to True.
Set the Align property to alTop. 
2. Add a splitter control to the form.
Set the Align property to alTop.
Set the Cursor property to crVSplit.
Set the OnMoved event handler to the code that appears below.
Set the MinSize property to 1.
3. Add a second image control to the form.
Set the Align property to alClient.
Set the Stretch property to True.
4. Select the form and add the OnCreate and OnDestroy event handlers that appear below.
5. Add the global variables below to the unit.
*) 
int CurImage;
Graphics::TBitmap *BMPs[5];
void __fastcall TForm1::Splitter1Moved(TObject *Sender)
{
  // check if the blind is closed
  if (Image2->Height <= 1)
  {
    // the blind is closed, change the current slide
    CurImage++;
    if (CurImage == 5)
       CurImage = 0;
    Image2->Picture->Bitmap = BMPs[CurImage];
  }
}
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // Initialize the array of slides.
  // These must be freed in the OnDestroy event handler.
  BMPs[0] = new Graphics::TBitmap();
  BMPs[0]->LoadFromFile("C:\\Windows\\Fiddle Head.bmp");
  BMPs[1] = new Graphics::TBitmap();
  BMPs[1]->LoadFromFile("C:\\Windows\\Rhododendron.bmp");
  BMPs[2] = new Graphics::TBitmap();
  BMPs[2]->LoadFromFile("C:\\Windows\\Furry Dog.bmp");
  BMPs[3] = new Graphics::TBitmap();
  BMPs[3]->LoadFromFile("C:\\Windows\\Soap Bubbles.bmp");
  BMPs[4] = new Graphics::TBitmap();
  BMPs[4]->LoadFromFile("C:\\Windows\\Gone Fishing.bmp");
  CurImage = 0;
  Image2->Picture->Bitmap = BMPs[0];
}
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
// clean up
  for (int I = 0; I < 5; I++)
    delete BMPs[I];
}
 
