/*
TPaintBox OnPaint example
When you do custom drawing, such as shown in the code for the Button's OnClick event handler below, this drawing will not be persistent and will be "erased" the first time the PaintBox component needs to repaint.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
   PaintBox1->Canvas->Brush->Color = clRed;
   PaintBox1->Canvas->FillRect(PaintBox1->Canvas->ClipRect);
   PaintBox1->Canvas->Ellipse(0,0,100,100);
}
/*
In order for the drawing to be persistent, you need to also include an OnPaint event handler that tells the PaintBox how to redraw itself when it needs to. In the code below, an ellipse will be drawn everytime the PaintBox renders itself, but the PaintBox will only paint the client area of the control red after the Button is clicked. This client area will only stay red until it is invalidated, but the ellipse will persist. This behavior is different from the TImage component, because the TImage component maintains an internal bitmap that stores this drawing information for you.
*/
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
   PaintBox1->Canvas->Ellipse(0,0,100,100);
} 
