/*
Min, Max, Position, SmallChange, LargeChange, OnScroll example
This example shows how to use a scroll bar to navigate the pages of a page control.  To run this example, place a scroll bar and a page control on a form.  Right click the page control and add 12 pages to it.  Add the following code to the OnCreate event of the form, the OnChange event of the page control, and the OnScroll event of the scroll bar.
Note that the LargeChange and SmallChange properties are set to automatically change the active page by one tab or one row respectively.  The OnScroll event is used to make the actual change in the page control, while the OnChange event of the page control ensures that the scroll bar is kept in sync with changes made directly to the page control.
*/ 
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // First, initialize the page control 
  PageControl1->TabWidth = PageControl1->ClientWidth/4 - 1;
  PageControl1->ActivePage = PageControl1->Pages[0];
  /* set up the scrollbar to reflect 
     the structure of the page control */
  ScrollBar1->Max = PageControl1->PageCount - 1;
  ScrollBar1->Min = 0;
  ScrollBar1->SmallChange = 1;
  // set LargeChange to a single row of tabs 
  ScrollBar1->LargeChange = PageControl1->ClientWidth / PageControl1->TabWidth;
}
void __fastcall TForm1::PageControl1Change(TObject *Sender)
{
  ScrollBar1->Position = ((TPageControl *)Sender)->ActivePage->PageIndex;
}

void __fastcall TForm1::ScrollBar1Scroll(TObject *Sender, TScrollCode ScrollCode, int &ScrollPos)
{
  PageControl1->ActivePage = PageControl1->Pages[ScrollPos];
} 
