/*
OnSelectionChange example
This example requires a TStatusBar and a TRichEdit.  The code within the form's OnCreate will take care of sizing the Rich Edit and setting the OnSelectionChange event to be handled by RichEdit1SelectionChange (or you can paste the code directly into the OnSelectionChange event handler.)
As you type in the Rich Edit control, the current character location the selection begin and end will display in the status bar control.
*/ 
procedure TForm1.RichEdit1SelectionChange(Sender: TObject);
begin
  with RichEdit1 do
    StatusBar1.SimpleText := '  Selection Start: ' + IntToStr(SelStart) +
      '  Selection End: ' + IntToStr(SelStart + SelLength);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  with RichEdit1 do
  begin
    Align := alClient;
    OnSelectionChange := RichEdit1SelectionChange;
  end;
  StatusBar1.SimplePanel := True;
end;
 
