//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OnSettingChange.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: OnSettingChange
// Event: AppEvnts.TCustomApplicationEvents.OnSettingChange
// Variable: SysUtils.SysLocale
// Routine: SysUtils.BoolToStr
// Method: Classes.TStrings.BeginUpdate
// Method: Classes.TStrings.EndUpdate

// BeginCode
/*
This example requires that a memo and a TApplicationEvent be
added to the form.  Change the Windows Locale by using the
Regional and Language Options in the Windows Control Panel.
*/
void __fastcall TForm1::ApplicationEvents1SettingChange(TObject *Sender, int Flag, const AnsiString Section, int &Result)
{
  Memo1->Lines->BeginUpdate();
  try
  {
//    char buffer[64];
	AnsiString buffer;
	buffer.sprintf("Section = %s", Section.c_str());
	Memo1->Lines->Add(buffer);
	buffer.sprintf("Flag = %8x", Flag);
	Memo1->Lines->Add(buffer);
	if (strcmp(Section.c_str(), "intl") == 0)
	{
	  buffer.sprintf("DefaultLCID = %8x", SysLocale.DefaultLCID);
	  Memo1->Lines->Add(buffer);
	  buffer.sprintf("PriLangID = %8x", SysLocale.PriLangID);
	  Memo1->Lines->Add(buffer);
	  buffer.sprintf("SubLangID = %8x", SysLocale.SubLangID);
	  Memo1->Lines->Add(buffer);
	  buffer.sprintf("FarEast = %s", BoolToStr(SysLocale.FarEast, true));
	  Memo1->Lines->Add(buffer);
	  buffer.sprintf("MiddleEast = %s", BoolToStr(SysLocale.MiddleEast, true));
      Memo1->Lines->Add(buffer);
	  Memo1->Lines->Add("");
    }
  }
  __finally
  {
    Memo1->Lines->EndUpdate();
  }
}
// EndCode
// EndExample: OnSettingChange
//---------------------------------------------------------------------------
