//--------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "UsingPictureDialogsExample.h"
//--------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//--------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}
//--------------------------------------------------------------------

// BeginExample: UsingPictureDialogs
// Class: ExtDlgs.TOpenPictureDialog
// Class: ExtDlgs.TSavePictureDialog
// Method: ExtDlgs.TOpenPictureDialog.Execute
// Method: ExtDlgs.TSavePictureDialog.Execute

// BeginCode
/*
This example uses an image, two buttons, an open picture dialog
and a save picture dialog on a form. Clicking on the Open/Save button
executes the open/save picture dialog.
An exception is raised when trying to open a file that
does not exist, or when trying to overwrite a file using the
save dialog.
*/
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Image1->Canvas->Refresh();
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  // execute an open picture dialog
  if (OpenPictureDialog1->Execute())
    // first check if file exists
    if (FileExists(OpenPictureDialog1->FileName))
      // if it exists, load the data into the image component
      Image1->Picture->LoadFromFile(OpenPictureDialog1->FileName);
    else
      // otherwise raise an exception
      throw(Exception("File does not exist."));
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  // execute a save picture dialog
  if (SavePictureDialog1->Execute())
    // first check if file exists
    if (FileExists(SavePictureDialog1->FileName))
      // if it exists, raise an exception
      throw(Exception("File already exists. Cannot overwrite."));
    else
      // otherwise, save the image data into the file
      Image1->Picture->SaveToFile(SavePictureDialog1->FileName);
}
// EndCode
// EndExample: UsingPictureDialogs
//--------------------------------------------------------------------

