/*
PageSize example
The following code sets the thumb tab of a scroll bar so that it represents the proportion of the scrolling range that is visible:
*/
// Get the minimum (default) size of the thumb tab 
int MinHeight = GetSystemMetrics(SM_CYVTHUMB);
// Get the size of the scrollbar track
int TrackHeight = ScrollBar1->ClientHeight - 2*GetSystemMetrics(SM_CYVSCROLL);
// set PageSize to represent the visible portion of the scrolling range:
ScrollBar1->PageSize = TrackHeight/(ScrollBar1->Max - ScrollBar1->Min + 1);
// Dont let the thumb tab get too small
if (ScrollBar1->PageSize < MinHeight)
  ScrollBar1->PageSize = MinHeight; 
