/*
PopupComponent, PopupMenu example
This example uses two edit boxes and one pop-up menu on a form. The pop-up menu contains Cut, Copy, and Paste commands. This code makes the pop-up menu available to both edit boxes:
*/ 
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  PopupMenu1->AutoPopup = true;
  Edit1->PopupMenu = PopupMenu1;
  Edit2->PopupMenu = PopupMenu1;
}
/*
These are the cut, copy, and paste OnClick events for the commands on the pop-up menu. 
*/ 
void __fastcall TForm1::Copy1Click(TObject *Sender)
{
  TComponent *pComponent = PopupMenu1->PopupComponent;
  if (pComponent)
  {
    if (pComponent->ClassNameIs("TEdit"))
      ((TEdit *)pComponent)->CopyToClipboard();
    else
      MessageBeep(0);
  }
  else
    MessageBeep(0);
}
void __fastcall TForm1::Cut1Click(TObject *Sender)
{
  TComponent *pComponent = PopupMenu1->PopupComponent;
  if (pComponent)
  {
    if (pComponent->ClassNameIs("TEdit"))
      ((TEdit *)pComponent)->CutToClipboard();
    else
      MessageBeep(0);
  }
  else
    MessageBeep(0);
}
void __fastcall TForm1::Paste1Click(TObject *Sender)
{
  TComponent *pComponent = PopupMenu1->PopupComponent;
  if (pComponent)
  {
    if (pComponent->ClassNameIs("TEdit"))
      ((TEdit *)pComponent)->PasteFromClipboard();
    else
      MessageBeep(0);
  }
  else
    MessageBeep(0);
} 
