//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "RecordCount.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

#include <DBTables.hpp>
TForm1 *Form1;
TTable *Customers;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: RecordCount
// Property: ComCtrls.TProgressBar.Min
// Property: ComCtrls.TProgressBar.Max
// Property: ComCtrls.TProgressBar.Position
// Property: DB.TDataSet.RecordCount
// Method: DB.TDataSet.First
// Method: DB.TDataSet.Next
// Method: DB.TDataSet.AppendRecord

// BeginCode
/*
Reads through all records in the Customers table.
Updates the ProgressBar accordingly.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  ProgressBar1->Min = 0;
  ProgressBar1->Max = Customers->RecordCount;
  Customers->First();
  for (int i = ProgressBar1->Min; i <= ProgressBar1->Max; i++)
  {
    ProgressBar1->Position = i;
	Customers->Next();
	// do something with the current record
  }
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Customers = new TTable(Form1); // The owner will clean this up.
  Customers->Active = false; // The Table component must not be active
  Customers->DatabaseName = "DBDEMOS";
  Customers->TableType = ttParadox;
  Customers->TableName = "CustInfo";
  Customers->Active = False;
  if (Customers->Exists) // Don't overwrite an existing table
  {
	Customers->Close();
	Customers->DeleteTable();
  }
  // The Table component must not be active
  // First, describe the type of table and give
  // it a name
  // Next, describe the fields in the table
  Customers->FieldDefs->Clear();
  TFieldDef *pNewDef = Customers->FieldDefs->AddFieldDef();
  pNewDef->Name = "Field1";
  pNewDef->DataType = ftInteger;
  pNewDef->Required = true;
  pNewDef = Customers->FieldDefs->AddFieldDef();
  pNewDef->Name = "Field2";
  pNewDef->DataType = ftString;
  pNewDef->Size = 30;
  // Next, describe any indexes
  Customers->IndexDefs->Clear();
  /* the 1st index has no name because it is a Paradox primary key */
  Customers->IndexDefs->Add("","Field1", TIndexOptions() <<ixPrimary << ixUnique);
  Customers->IndexDefs->Add("Fld2Index","Field2", TIndexOptions() << ixCaseInsensitive);
  // Now that we have specified what we want, create the table
  Customers->CreateTable();
  Customers->Active = True;
  for (int i = 1; i <= 20; i++)
	Customers->AppendRecord(ARRAYOFCONST((i*111, i*222)));
  DS2->DataSet = Customers;
  DBGrid2->DataSource->DataSet = Customers;
  Customers->Active = True;
}
// EndCode
// EndExample: RecordCount
//---------------------------------------------------------------------------

