//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "RegisterComponents.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
// BeginExample: RegisterComponents
// Routine: Classes.RegisterComponents
// Method: Classes.TComponent.FreeNotification

// BeginCode
/*
The following code registers several components, some on the
MySystem palette page that already exist, and some on a new
palette page that is created when the components are
installed.
*/

void __fastcall PACKAGE Register()
{
  TComponentClass classes[1] = {__classid(TDemoLabel)};
  RegisterComponents("Samples", classes, 0);
  RegisterComponents("MySystem", classes, 0);
}

__fastcall TDemoLabel::TDemoLabel(TComponent *AOwner):
	TGraphicControl(AOwner)
{
  FComponentStyle >> csInheritable;
  Width=64;
  Height=13;
}

void __fastcall	TDemoLabel::Notification(TComponent *AComponent, TOperation Operation)
{
  TGraphicControl::Notification(AComponent, Operation);
  if ((Operation == opRemove)  && (AComponent == FFocusControl))
    FFocusControl = 0;
}

void __fastcall	TDemoLabel::SetFocusControl(TWinControl *Value)
{
  FFocusControl = Value;

  // Calling FreeNotification ensures that this component will receive an
  // opRemove when Value is either removed from its owner or when it is
  // destroyed.

  Value->FreeNotification(Value);
}

void __fastcall	TDemoLabel::Paint()
{
  TRect	Rect = ClientRect;
  Canvas->Font = Font;
  Canvas->Brush->Color = Color;
  Canvas->FillRect(Rect);
  DrawText(
	Canvas->Handle,
	Caption.t_str(),
	Caption.Length(),
	&Rect,
	DT_EXPANDTABS | DT_WORDBREAK | DT_LEFT);
}

void __fastcall	TDemoLabel::CMDialogChar(TCMDialogKey &Message)
{
  if (FFocusControl != NULL &&
      Enabled == true &&
      IsAccel(Message.CharCode, Caption))
      if (FFocusControl->CanFocus()){
        FFocusControl->SetFocus();
        Message.Result = 1;
      }
}

void __fastcall	TDemoLabel::CMTextChanged(TMessage &Message)
{
  Invalidate();
}
// EndCode
// EndExample: RegisterComponents
//---------------------------------------------------------------------------
