/*
OnReplace, ReplaceText example
The following event handler searches a TMemo object called Memo1 and replaces FindText with ReplaceText. It uses TMemos SelStart, SelLength, and SelText properties.
*/ 
void __fastcall TForm1::ReplaceDialog1Replace(TObject *Sender)
{
  TReplaceDialog *dlg = (TReplaceDialog *)Sender;
  /* perform a global case-sensitive search for FindText in Memo1 */
  int SelPos = Memo1->Lines->Text.Pos(dlg->FindText);
  if (SelPos > 0)
  {
    Memo1->SelStart = SelPos - 1;
    Memo1->SelLength = dlg->FindText.Length();
    // Replace selected text with ReplaceText
    Memo1->SelText = dlg->ReplaceText;
  }
  else
    MessageBeep(0);
} 
