/*
Rotated Font example
This example creates a rotated font and displays it on the form by assigning the handle of the rotated to the Forms Canvas Font via the Fonts Handle property. 
Rotating fonts is a straightforward process, so long as the Windows Font Mapper can supply a rotated font based on the font you request. If you are using a TrueType font there is virtually no reason for failure.
*/ 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
    LOGFONT lf; // Windows native font structure

    Canvas->Brush->Style = bsClear; // set the brush style to transparent
    ZeroMemory(&lf, sizeof(LOGFONT));

    lf.lfHeight = 20;
    lf.lfEscapement = 10 * 45; // degrees to rotate
    lf.lfOrientation = 10 * 45;
    lf.lfCharSet = DEFAULT_CHARSET;
    strcpy(lf.lfFaceName, "Tahoma");

    Canvas->Font->Handle = CreateFontIndirect(&lf);
    Canvas->TextOut(10, 100, "Rotated text"); // output the rotated font
} 
