//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SavePictureDialog.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: SavePictureDialog
// Routine: Graphics.GraphicExtension
// Routine: Graphics.GraphicFilter
// Method: Dialogs.TOpenDialog.DefaultExt
// Property: Dialogs.TOpenDialog.Filter
// Property: Dialogs.TOpenDialog.FileName
// Method: ActnList.TCustomAction.Execute

// BeginCode
/*
This code displays a Save Picture dialog box with the
TBitmap default extension that is added automatically to
files that are given no extension. Confirm that the
bitmap file has been saved under the filename and path
specified.
*/
#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  AnsiString NewFileName, OldFileName;
  SavePictureDialog1->DefaultExt = GraphicExtension(__classid(Graphics::TBitmap));
  SavePictureDialog1->Filter = GraphicFilter(__classid(Graphics::TBitmap));
  OldFileName = "factory.bmp";
  if (SavePictureDialog1->Execute())
  {
	NewFileName = SavePictureDialog1->FileName;
	std::auto_ptr<TFileStream> OldFile(new TFileStream(OldFileName, (fmOpenRead | fmShareDenyWrite)));
	std::auto_ptr<TFileStream> NewFile(new TFileStream(NewFileName, (fmCreate | fmShareDenyRead)));
	NewFile->CopyFrom(OldFile.get(), OldFile->Size);
  };
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Image1->Picture->LoadFromFile("../factory.bmp");
}
// EndCode
// EndExample: SavePictureDialog
//---------------------------------------------------------------------------
