//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SaveToFile.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: SaveToFile
// Method: Graphics.TPicture.SaveToFile
// Method: Graphics.TIcon.Create
// Property: Graphics.TGraphic.Height
// Property: Graphics.TGraphic.Width
// Property: ExtCtrls.TImage.Canvas
// Routine: SysUtils.ChangeFileExt

// BeginCode
/*
This example converts a specified icon to a bitmap. To run 
this example, add an image, a button, and an Open dialog to 
a form. Name the button ConvertIcon2Bitmap, and add the 
following code as its OnClick event handler.
*/

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::ConvertIcon2BitmapClick(TObject *Sender)
{
  OpenDialog1->DefaultExt = ".ICO";
  OpenDialog1->Filter = "icons (*.ico)|*.ICO";
  OpenDialog1->Options << ofOverwritePrompt << ofFileMustExist << ofHideReadOnly;
  if (OpenDialog1->Execute())
  {
	std::auto_ptr<TIcon> pi(new Graphics::TIcon);
	AnsiString as;
	pi->LoadFromFile(OpenDialog1->FileName);
	as = ChangeFileExt(OpenDialog1->FileName,".BMP");
	Image1->Width = pi->Width;
	Image1->Height = pi->Height;
	Image1->Canvas->Draw(0, 0, pi.get());
	Image1->Picture->SaveToFile(as);
	ShowMessage(OpenDialog1->FileName + " Saved to " + as);
  }
}
// EndCode
// EndExample: SaveToFile
//---------------------------------------------------------------------------
