//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ScanLine.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: ScanLine
// Property: Graphics.TBitmap.ScanLine
// Property: Graphics.TGraphic.Height
// Property: Graphics.TGraphic.Width
// Property: Graphics.TBitmap.PixelFormat

// BeginCode

/*
This example shows how to draw directly to a Bitmap.  It
loads a bitmap from a file and then copies it to another
bitmap twice it's size.  Then the two bitmaps are
displayed on the form canvas.
*/

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  std::auto_ptr<Graphics::TBitmap> Bitmap(new Graphics::TBitmap);
  std::auto_ptr<Graphics::TBitmap> BigBitmap(new Graphics::TBitmap);
  TRGBTriple *ptr, *bigPtr;   // use a (byte *) for pf8bit color
  TPixelFormat pixForm, bigpixForm;
  try
  {
	Bitmap->LoadFromFile("../littlefac.bmp");
	pixForm = Bitmap->PixelFormat;
	bigpixForm  = BigBitmap->PixelFormat;
	Bitmap->PixelFormat = pf24bit;
	BigBitmap->PixelFormat = pf24bit;
	BigBitmap->Height = Bitmap->Height * 2;
	BigBitmap->Width = Bitmap->Width * 2;
	for (int y = 0; y < Bitmap->Height; y++)
    {
	  ptr = reinterpret_cast<TRGBTriple *>(Bitmap->ScanLine[y]);
	  for (int x = 0; x < Bitmap->Width; x++)
	  {
		int bx = x * 2;
		int by = y * 2;
		bigPtr = reinterpret_cast<TRGBTriple *>(BigBitmap->ScanLine[by]);
		bigPtr[bx] = ptr[x];
		bigPtr[bx + 1] = ptr[x];
		bigPtr = reinterpret_cast<TRGBTriple *>(BigBitmap->ScanLine[by + 1]);
		bigPtr[bx] = ptr[x];
		bigPtr[bx + 1] = ptr[x];
	  }
	}
	Canvas->Draw(0, 0, Bitmap.get());
	Canvas->Draw(200, 200, BigBitmap.get());
  }
  catch (...)
  {
    ShowMessage("Could not load or alter bitmap");
  }
}
// EndCode
// EndExample: ScanLine
//---------------------------------------------------------------------------
