/*
SelStart, SelLength example
The following example shows how to complete partial strings typed into a combo box. The code represents the OnKeyPress event handler of the combo box, which performs most of the default keystroke handling before finding a matching list item and updating the text. 
Note:	This OnKeyPress event handler does not deal with the case when the user types the Delete key. That case must be caught in the OnKeyDown event handler instead.
*/ 
void __fastcall TForm1::ComboBox1KeyPress(TObject *Sender; char &Key)
{
  // first, process the keystroke to obtain the current string
  // This code requires all items in list to be uppercase
  if (Key >= 'a' && Key <= 'z')
    Key -= 32; // Force Uppercase only!
  TComboBox *pCB = (TComboBox *)Sender;
  AnsiString TmpStr;
  bool BackSpace = (Key == (char)VK_BACK);
  if (BackSpace && pCB->SelLength)
    TmpStr = pCB->Text.SubString(1,pCB->SelStart)+
             pCB->Text.SubString(pCB->SelLength+pCB->SelStart+1,255);
  else if (BackSpace) // SelLength == 0
    TmpStr = pCB->Text.SubString(1,pCB->SelStart-1)+
             pCB->Text.SubString(pCB->SelStart+1,255);
  else //Key is a visible character
    TmpStr = pCB->Text.SubString(1,pCB->SelStart)+ Key +
             pCB->Text.SubString(pCB->SelLength+pCB->SelStart+1,255);
  if (TmpStr.IsEmpty())
    return;
  // set SelSt to the current insertion point
  int SelSt = pCB->SelStart;
  if (BackSpace && SelSt > 0)
    SelSt--;
  else if (!BackSpace)
    SelSt++;
  Key = 0; // indicate that key was handled
  if (SelSt == 0)
  {
    pCB->Text = "";
    return;
  }
  // Now that TmpStr is the currently typed string, see if we can locate a match
  bool Found = false;
  for (int i = 1; i < pCB->Items->Count; i++)
    if (TmpStr == pCB->Items->Strings[i-1].SubString(1,TmpStr.Length()))
    {
      pCB->Text = pCB->Items->Strings[i-1]; // update to the match that was found
      pCB->ItemIndex = i-1;
      Found = true;
      break;
    }
  if (Found) // select the untyped end of the string
  {
    pCB->SelStart = SelSt;
    pCB->SelLength = pCB->Text.Length()-SelSt;
  }
  else Beep();
} 
