//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SelStart.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Memo1->Lines->LoadFromFile("..\\country.list");
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  FindDialog1->Execute();
}
//---------------------------------------------------------------------------
// BeginExample: SelStart
// Method: Controls.TWinControl.SetFocus
// Property: StdCtrls.TCustomEdit.SelStart
// Property: StdCtrls.TCustomEdit.SelLength

// BeginCode
/*
The following OnFind event handler searches a memo component
for the text specified in the FindText property of a find
dialog component. If found, the first occurrence of the text
in Memo1 is selected. The code uses the Pos function to
compare strings, and stores the number of characters to skip
when determining the selection position in the SkipChars
variable. Because there is no handling of case, whole word,
or search direction in this algorithm, it is assumed that
the Options property of FindDialog1 is set to
[frHideMatchCase, frHideWholeWord, frHideUpDown].
*/
void __fastcall TForm1::FindDialog1Find(TObject *Sender)
{
  for (int I = 0; I < Memo1->Lines->Count; I++)
  {
    int PosReturn = Memo1->Lines->Strings[I].Pos(FindDialog1->FindText);
    if (PosReturn) //found!
    {
      int Skipchars = 0;
      for (int J = 0; J < I; J++)
        Skipchars += Memo1->Lines->Strings[J].Length();
      Skipchars += I*2; // add CR/LF for all skipped lines
      Skipchars += PosReturn - 1;
      Memo1->SetFocus();
      Memo1->SelStart = Skipchars;
      Memo1->SelLength = FindDialog1->FindText.Length();
      break;
    }
  }
}
// EndCode
// EndExample: SelStart
//---------------------------------------------------------------------------
