/*
SetFocus, SelStart, SelLength example
The following OnFind event handler searches a memo component for the text specified in the FindText property of a find dialog component. If found, the first occurrence of the text in Memo1 is selected. The code uses the Pos function to compare strings, and stores the number of characters to skip when determining the selection position in the Skipchars variable. Because there is no handling of case, whole word, or search direction in this algorithm, it is assumed that the Options property of FindDialog1 was set to include frHideMatchCase, frHideWholeWord, and frHideUpDown.
*/ 
void __fastcall TForm1::FindDialog1Find(TObject *Sender)
{
  for (int I = 0; I < Memo1->Lines->Count; I++)
  {
    int PosReturn = Memo1->Lines->Strings[I].Pos(FindDialog1->FindText);
    if (PosReturn) //found!
    {
      int Skipchars = 0;
      for (int J = 0; J < I; J++)
        Skipchars += Memo1->Lines->Strings[J].Length();
      Skipchars += I*2; // add CR/LF for all skipped lines
      Skipchars += PosReturn - 1;
      Memo1->SetFocus();
      Memo1->SelStart = Skipchars;
      Memo1->SelLength = FindDialog1->FindText.Length();
      break;
    }
  }
} 
