//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SelText.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: SelText
// Method: StdCtrls.TCustomEdit.GetSelTextBuf
// Property: StdCtrls.TCustomEdit.SelText

// BeginCode
/*
This example copies selected text from one text edit to
another.  This example requires two text edits and two buttons.
*/
Char *Buffer;

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  int Size = Edit1->SelLength; //Get length of selected text in Edit1
  Size++;                      //Add room for null character
  static std::auto_ptr<Char> _BufferCleaner(Buffer = new Char[Size]);
  Edit1->GetSelTextBuf(Buffer, Size); //Puts Edit1->Text into Buffer
  Edit2->Text = Buffer;
}
//---------------------------------------------------------------------------
/*
Note: the same thing could be accomplished more simply as follows:
*/
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  Edit2->Text = Edit1->SelText;
}
// EndCode
// EndExample: SelText
//---------------------------------------------------------------------------
