//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MessagesExample.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm4 *Form4;
//---------------------------------------------------------------------------
__fastcall TForm4::TForm4(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: Messages
// Routine: Messages.SendGetIntMessage
// Routine: Messages.SendStructMessage
// Routine: Messages.SendGetStructMessage
// Routine: Messages.SendTextMessage

// Warning: Bruneau's thunks

// BeginCode
/*
This is an example demonstrating the usage of the SendGetIntMessage,
SendStructMessage, SendGetStructMessage and SendTextMessage message
functions.
This example uses four buttons and six text edit boxes as follows:
- Button1 //SendGetIntMessage
- Button2 //SendStructMessage
- Button3 //SendGetStructMessage
- Button4 //SendTextMessage

- IntEdit //for int inputs
- StructEdit1 & StructEdit2 //for struct inputs (ints)
- GetStructEdit1 & GetStructEdit2 //for struct inputs (ints)
- TextEdit //for text input

Note: This example generates unresolved external errors with the
default NO_STRICT conditional define set.  The work around is
to use the STRICT conditional define.  This problem is addressed
in the RAID bug #267447.

This example uses three custom message structures defined in the header:
struct TMyIntMessage {
	Cardinal Msg;
	int* wparam;
	int* lparam;
	LRESULT Result;
};

struct TMyTextMessage {
	Cardinal Msg;
	int wparam;
	String lparam;
	LRESULT Result;
};

struct MStruct {
	int m_a;
	int m_b;
};

struct TMyStruct {
	Cardinal Msg;
	int wparam;
	MStruct* lparam;
	LRESULT Result;
};

Furthermore it uses 4 message handling functions described in the
header along with a message map:

MESSAGE void __fastcall UserIntHandler(TMyIntMessage &msg);
MESSAGE void __fastcall UserStructHandler(TMyStruct &msg);
MESSAGE void __fastcall UserGetStructHandler(TMyStruct &msg);
MESSAGE void __fastcall UserTextHandler(TMyTextMessage &msg);

BEGIN_MESSAGE_MAP
	MESSAGE_HANDLER(WM_INTMESSAGE, TMyIntMessage, UserIntHandler);
	MESSAGE_HANDLER(WM_GETSTRUCTMESSAGE, TMyStruct, UserGetStructHandler);
	MESSAGE_HANDLER(WM_STRUCTMESSAGE, TMyStruct, UserStructHandler);
	MESSAGE_HANDLER(WM_TEXTMESSAGE, TMyTextMessage, UserTextHandler);
END_MESSAGE_MAP(TComponent)

*/

void __fastcall TForm4::UserIntHandler(TMyIntMessage &msg){
	MessageDlg("Int message received: " + IntToStr(*msg.lparam),
			mtInformation, TMsgDlgButtons() << mbOK, 0);

	*msg.lparam = *msg.lparam + 50;
}
void __fastcall TForm4::UserStructHandler(TMyStruct &msg){
	MessageDlg("Struct received: " + IntToStr(msg.lparam->m_a) +
				" " + IntToStr(msg.lparam->m_b),
			mtInformation, TMsgDlgButtons() << mbOK, 0);
}
void __fastcall TForm4::UserGetStructHandler(TMyStruct &msg){
	MessageDlg("Struct received: " + IntToStr(msg.lparam->m_a) +
			"" + IntToStr(msg.lparam->m_b),
			mtInformation, TMsgDlgButtons() << mbOK, 0);
	msg.lparam->m_a = msg.lparam->m_a + 50;
	msg.lparam->m_b = msg.lparam->m_b + 50;
}
void __fastcall TForm4::UserTextHandler(TMyTextMessage &msg){
	MessageDlg("Text received: " + msg.lparam,
			mtInformation, TMsgDlgButtons() << mbOK, 0);
}
void __fastcall TForm4::Button1Click(TObject *Sender)
{
	int wparam = 0;
	int lparam = StrToIntDef(IntEdit->Text,0);
	int lbase = lparam;

	SendGetIntMessage(Handle,WM_INTMESSAGE,wparam,lparam);

	if (lbase != lparam)
	{
		MessageDlg("Value modified by handler function: " +
					IntToStr(lparam),
					mtInformation, TMsgDlgButtons() << mbOK, 0);
		IntEdit->Text = IntToStr(lparam);
	}

}
//---------------------------------------------------------------------------

void __fastcall TForm4::Button2Click(TObject *Sender){
	int wparam = 0;
	String lparam = TextEdit->Text;

	SendTextMessage(Handle,WM_TEXTMESSAGE,wparam,lparam);
}
//---------------------------------------------------------------------------

void __fastcall TForm4::Button3Click(TObject *Sender)
{
	int wparam = 0;
	MStruct lparam;

	lparam.m_a = StrToIntDef(StructEdit1->Text,0);
	lparam.m_b = StrToIntDef(StructEdit2->Text,0);

	SendStructMessage(Handle, WM_STRUCTMESSAGE, wparam, &lparam);
}
//---------------------------------------------------------------------------

void __fastcall TForm4::Button4Click(TObject *Sender)
{
	int wparam = 0;
	MStruct lparam, lbase;

	lparam.m_a = StrToIntDef(GetStructEdit1->Text,0);
	lparam.m_b = StrToIntDef(GetStructEdit2->Text,0);

	lbase = lparam;

	SendStructMessage(Handle, WM_GETSTRUCTMESSAGE, wparam, &lparam);

	if (lbase.m_a != lparam.m_a) {
    	MessageDlg("Struct modified by handler function: " +
					IntToStr(lparam.m_a) + " " + IntToStr(lparam.m_b),
					mtInformation, TMsgDlgButtons() << mbOK, 0);
		GetStructEdit1->Text = IntToStr(lparam.m_a);
		GetStructEdit2->Text = IntToStr(lparam.m_b);
	}
}
//---------------------------------------------------------------------------

// EndCode
// EndExample: Messages
