//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Set8087CW.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: Set8087CW
// Routine: System.Set8087CW
// Variable: System.Default8087CW

// BeginCode
/*
This example accesses the Floating Point Unit (FPU) control
register.  Try turning floating point exceptions off and on
and dividing a number by zero to test it.
*/
Word Saved8087CW;

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Edit3->Text = FloatToStr(StrToFloat(Edit1->Text) / StrToFloat(Edit2->Text));
}

void __fastcall TForm1::RadioGroup1Click(TObject *Sender)
{
  if (RadioGroup1->Items->Strings[RadioGroup1->ItemIndex] == "FPU Exceptions")
	System::Set8087CW(Saved8087CW);
  if (RadioGroup1->Items->Strings[RadioGroup1->ItemIndex] == "No FPU Exceptions")
	System::Set8087CW(0x133f); // Disable all fpu exceptions
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RadioGroup1->Items->Add("No FPU Exceptions");
  RadioGroup1->Items->Add("FPU Exceptions");
  RadioGroup1->ItemIndex = 2;
  Saved8087CW = Default8087CW;  // Save this because Set8087CW changes it!
}

void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  System::Set8087CW(Saved8087CW); // Default value (with exceptions) is 0x1372
}
// EndCode
// EndExample: Set8087CW
//---------------------------------------------------------------------------

