//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SetEnumProp.h"
#include <TypInfo.hpp>
#include <fstream.h>
#include <Dialogs.hpp>
#include <time.h>
#include <TypInfo.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: SetEnumProp
// Routine: TypInfo.SetEnumProp
// Routine: TypInfo.GetEnumProp

// BeginCode
/*
This example shows how to use GetEnumProp and SetEnumProp in order to
check for visual components properties and to change them.
This example uses two buttons, Button1 and Button2.
*/
void __fastcall TForm2::Button1Click(TObject *Sender)
{
	//getting the current color of the workspace
	String currentPropColor = GetEnumProp(this,"Color");
	int currentColorInt = StrToInt(currentPropColor);

	//getting the first button align enum and if different,
	//setting it to alLeft
	String currentAlignProp = GetEnumProp(Button1, "Align");
	if (currentAlignProp != "alLeft")
	{
		 SetEnumProp(Button1, "Align", "alLeft");
	 }

	//checking if the form background color was set.
	if(currentColorInt < 0)
	{
		currentColorInt = GetSysColor(COLOR_APPWORKSPACE);
	}

	//setting the form background color as the negative value
	//of the current background color
	SetEnumProp(this, "Color",
				IntToStr((int)(clWhite - currentColorInt)));
}

void __fastcall TForm2::Button2Click(TObject *Sender)
{
	int p[5] = {clYellow, clGreen, clRed, clBlue, clBlack};
	SetEnumProp(this, "Color", IntToStr(p[random(5)]));

	//getting the second button align enum and if different,
	//setting it to alRight
	String currentAlignProp = GetEnumProp(Button2, "Align");
	if (currentAlignProp != "alRight")
	{
		 SetEnumProp(Button2, "Align", "alRight");
	 }
}
// EndCode
// EndExample: SetEnumProp
//---------------------------------------------------------------------------

