//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ExtCtrls.hpp"
#include "FileCtrl.hpp"
#include "Splitter.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: Splitter
// Method: ExtCtrls.TSplitter.Create
// Property: ExtCtrls.TSplitter.MinSize
// Property: Controls.TControl.Align
// Property: Controls.TControl.Width
// Property: Forms.TCustomForm.ClientWidth
// Property: FileCtrl.TDirectoryListBox.FileList

// BeginCode
/*
This example shows how to use a splitter to divide a form 
into resizable panes.  All objects on the form are created 
dynamically in the OnCreate event handler of the form. To 
run this example, add ExtCtrls and FileCtrl to the uses 
clause of the forms implementation section.
Note that when creating a splitter dynamically at runtime, 
it is important to set its position to the appropriate side 
of the control it will resize.
*/

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TSplitter* ps = new TSplitter(Form1); // These objects will all be cleaned up by the owner (Form1).
  TFileListBox* pflb = new TFileListBox(Form1); // The parent (Form1) will clean up these objects.
  TDirectoryListBox* pdlb = new TDirectoryListBox(Form1);

  // Line up the directory list box on the left of the form.
  pdlb->Parent = Form1;
  pdlb->Align = alLeft;
  pdlb->Width = Form1->ClientWidth/3;

  // Now use the splitter to divide the directory pane from the file pane.
  ps->Parent = Form1;
  ps->Left = pdlb->Left + pdlb->Width + 1; // Move to right of directory list.
  ps->Align = pdlb->Align; // Give same alignment as directory list.

  // Each pane must be at least one quarter of the form's width.
  ps->MinSize = Form1->ClientWidth/4;

  // Finally, create the last pane - a file list box.
  pflb->Parent = Form1;
  pflb->Align = alClient;
  pdlb->FileList = pflb; // Link the file list box to the directory list box.
}
// EndCode
// EndExample: Splitter
//---------------------------------------------------------------------------

