/*
Splitter Example
This example shows how to use a splitter to divide a form into resizable panes. All objects on the form are created dynamically in the OnCreate event handler of the form. Remember to include extctrls.hpp and filectrl.hpp in your unit file.
Note that when creating a splitter dynamically at runtime, it is important to set its position to the appropriate side of the control it will resize.
*/
#include <Extctrls.hpp>
#include <Filectrl.hpp>
void __fastcall TForm1::Form1Create(TObject *Sender)
{
  TSplitter* ps = new TSplitter(Form1);
  TFileListBox* pflb = new TFileListBox(Form1);
  TDirectoryListBox* pdlb = new TDirectoryListBox(Form1);

  // Line up the directory list box on the left of the form.
  pdlb->Parent = Form1;
  pdlb->Align = alLeft;
  pdlb->Width = Form1->ClientWidth/3;

  // Now use the splitter to divide the directory pane from the file pane.
  ps->Parent = Form1;
  ps->Left = pdlb->Left + pdlb->Width + 1; // Move to right of directory list.
  ps->Align = pdlb->Align; // Give same alignment as directory list.

  // Each pane must be at least one quarter of the form's width.
  ps->MinSize = Form1->ClientWidth/4;

  // Finally, create the last pane - a file list box.
  pflb->Parent = Form1;
  pflb->Align = alClient;
  pdlb->FileList = pflb; // Link the file list box to the directory list box.
} 
