/*
StrECopy example
The following example uses an edit control, a label, and a button on a form. When the button is clicked, the edit controls text is appended to a static buffer. Then the buffer is displayed in the labels caption.
*/ 
const static int MAX_LENGTH = 65536;
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  static char szBuffer[MAX_LENGTH];
  static char* pszBuffer = szBuffer;

  // The following 2 lines are used in VCL applications
  if (StrLen(pszBuffer) + StrLen(Edit1->Text.c_str()) < MAX_LENGTH -1)
    pszBuffer = StrECopy(pszBuffer, Edit1->Text.c_str());
  // The following 2 lines are used in CLX applications
  // if (StrLen(pszBuffer) + StrLen(WideCharToString(Edit1->Text.c_bstr()).c_str()) < MAX_LENGTH -1)
  //   pszBuffer = StrECopy(pszBuffer, WideCharToString(Edit1->Text.c_bstr()).c_str());
  else
    ShowMessage("Can't fit new string in allocated memory space.");
  Label1->Caption = szBuffer;

  Edit1->Clear();
} 
